/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取控制芯片列表/显示芯片列表/行管芯片列表
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.03.02
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_get_hw_data */
/* exported mc_analysis_hw_data */
/* exported mc_adjust_tbl_dom */

/* global $ */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取硬件数据
 * 参数:
 *    @param {Promise<object>} obj_hardware 硬件实例对象
 *    @param {Promise<Function>} fn_callback 回调函数

 *  * 返回：
 *    @param {Promise<Array>} arr_hw_data 硬件数据
 *  * 备注:
 *  返回的数据 以children作为容器 除了接收卡以id,cnt为键的数据对象外 其余都是以id,children为键
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.03.02
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_hw_data(obj_hardware, fn_callback) {
    var arr_hw_data = [];
    // 读取硬件数据

    obj_hardware.get_sendscard_cnt(function (send_cnt) {
        var obj_temp = {
            id: "",
            children: []
        };

        var obj_r = {
            id: "R",
            cnt: ""
        };
        // 接收卡数量
        var ui_rece_cnt = "";
        // 接收卡使用对象
        var obj_r_all = "";

        // 发送卡端口
        for (var id_s = 0; id_s < send_cnt; id_s++) {
            // var obj_S = $.extend({}, obj_temp)
            var obj_S = JSON.parse(JSON.stringify(obj_temp));
            var id_s_name = "S_";

            id_s_name += id_s;
            obj_S.id = id_s_name;

            // 存发送卡
            arr_hw_data.push(obj_S);

            // 发送卡端口数量
            var ui_s_p_cnt = obj_hardware.get_port_cnt(id_s);

            for (var idx_s_p = 0; idx_s_p < ui_s_p_cnt; idx_s_p++) {
                // var obj_S_P = $.extend({}, obj_temp)
                var obj_S_P = JSON.parse(JSON.stringify(obj_temp));
                var id_s_p_name = "S_P_";

                id_s_p_name += idx_s_p;
                obj_S_P.id = id_s_p_name;
                // 存发送卡端口
                arr_hw_data[id_s].children.push(obj_S_P);

                // hub卡数量
                var ui_h_cnt = obj_hardware.get_hub_cnt(id_s, idx_s_p);
                // 根据是否有hub卡进行添加

                if (0 < ui_h_cnt) {
                    for (var id_h = 0; id_h < ui_h_cnt; id_h++) {
                        var obj_h = JSON.parse(JSON.stringify(obj_temp));
                        var id_h_name = "H_";

                        id_h_name += id_h;
                        obj_h.id = id_h_name;
                        arr_hw_data[id_s].children[idx_s_p].children.push(obj_h);

                        // hub卡端口
                        var ui_h_p_cnt = obj_hardware.get_hub_prot_cnt(id_s, idx_s_p, id_h);

                        for (var id_h_p = 0; id_h_p < ui_h_p_cnt; id_h_p++) {
                            var obj_h_p = JSON.parse(JSON.stringify(obj_temp));
                            var id_h_p_name = "H_P";

                            id_h_p_name += id_h_p;
                            obj_h_p.id = id_h_p_name;

                            arr_hw_data[id_s].children[idx_s_p].children[id_h].children.push(obj_h_p);

                            // 接收卡
                            ui_rece_cnt = obj_hardware.get_recvcard_cnt(id_s, idx_s_p, id_h, id_h_p);

                            obj_r_all = JSON.parse(JSON.stringify(obj_r));

                            obj_r_all.cnt = ui_rece_cnt;
                            arr_hw_data[id_s].children[idx_s_p].children[id_h].children[id_h_p].children.push(obj_r_all);
                        }
                    }
                } else {
                    // 接收卡
                    ui_rece_cnt = obj_hardware.get_recvcard_cnt(id_s, idx_s_p);

                    obj_r_all = JSON.parse(JSON.stringify(obj_r));

                    obj_r_all.cnt = ui_rece_cnt;
                    arr_hw_data[id_s].children[idx_s_p].children.push(obj_r_all);
                }
            }
        }

        fn_callback(arr_hw_data);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析硬件数据,生成表格控件数据
 * 参数:
 *    @param {Promise<Array>} arr_hw 硬件数据
 *    @param {Promise<Function>} fn_callback 回调函数

 *  * 返回：
 *    @param {Promise<Array>} arr_data table数据
 *    @param {Promise<Array>} arr_edit table数据是否可写
 *
 * 备注:
 * NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.03.02
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_analysis_hw_data(arr_hw, fn_callback) {
    var arr_data = [];
    var arr_edit = [];
    var str_null = "MC_LANG_OPTION_NULL";
    var str_s_id = 0;
    var str_s_p_id = 0;
    var str_h_cnt = 0;
    var str_h_p_cnt = 0;
    var str_r_cnt = "";

    var arr_temp = [];
    var arr_edit_temp = [false, false, false, false, false];

    // 发送卡

    for (var id_s = 0; id_s < arr_hw.length; id_s++) {
        ++str_s_id;
        str_s_p_id = 0;
        str_h_cnt = 0;
        str_h_p_cnt = 0;
        // 发送卡端口
        for (var id_p = 0; id_p < arr_hw[id_s].children.length; id_p++) {
            ++str_s_p_id;
            str_h_cnt = 0;
            str_h_p_cnt = 0;
            // 判断是否有hub卡

            for (var id_h_or_r = 0; id_h_or_r < arr_hw[id_s].children[id_p].children.length; id_h_or_r++) {
                ++str_h_cnt;

                if ("R" === arr_hw[id_s].children[id_p].children[id_h_or_r].id) {
                    str_r_cnt = arr_hw[id_s].children[id_p].children[id_h_or_r].cnt.toString();
                    arr_temp.push(str_s_id.toString());
                    arr_temp.push(str_s_p_id.toString());
                    arr_temp.push(str_null);
                    arr_temp.push(str_null);
                    arr_temp.push(str_r_cnt);
                    arr_data.push(arr_temp);
                    arr_edit.push(arr_edit_temp);
                    arr_temp = [];
                } else {
                    for (var id_h = 0; id_h < arr_hw[id_s].children[id_p].children[id_h_or_r].children.length; id_h++) {
                        str_h_p_cnt = (id_h + 1);
                        // ++str_h_p_cnt;
                        for (var id_h_p = 0; id_h_p < arr_hw[id_s].children[id_p].children[id_h_or_r].children[id_h].children.length; id_h_p++) {
                            // 获取接收卡
                            str_r_cnt = arr_hw[id_s].children[id_p].children[id_h_or_r].children[id_h].children[id_h_p].cnt.toString();
                            arr_temp.push(str_s_id.toString());
                            arr_temp.push(str_s_p_id.toString());
                            arr_temp.push(str_h_cnt.toString());
                            arr_temp.push(str_h_p_cnt.toString());
                            arr_temp.push(str_r_cnt);
                            arr_data.push(arr_temp);
                            arr_edit.push(arr_edit_temp);
                            arr_temp = [];
                        }
                    }
                }
            }
        }
    }


    fn_callback(arr_data, arr_edit);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理dom元素
 * 参数:
 *    @param {Promise<Array>} arr_li 硬件数据
 *    @param {Promise<Array>} arr_hw_date 硬件数据
 *    @param {Promise<number>} ui_grid_h 硬件数据

 *  * 返回：
 *    NA
 * 备注:
 * NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.03.02
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_adjust_tbl_dom(arr_li, arr_hw_date, ui_grid_h) {
    var arr_s_list = [];
    var arr_s_p_list = [];
    var arr_h_list = [];
    // var arr_h_p_list = [];


    for (var id = 0; id < arr_hw_date.length; id++) {
        arr_s_list.push(arr_hw_date[id][0]);
        arr_s_p_list.push(arr_hw_date[id][1]);
        arr_h_list.push(arr_hw_date[id][2]);
    }

    mc_ajust_list(arr_s_list, ui_grid_h, arr_li, 0);
    mc_ajust_list(arr_s_p_list, ui_grid_h, arr_li, 1);
    mc_ajust_list(arr_h_list, ui_grid_h, arr_li, 2, arr_s_p_list);

    // 添加hub卡端口跟接收卡的样式
    for (let id_p_r = 0; id_p_r < arr_li.length; id_p_r++) {
        $(arr_li[id_p_r].childNodes[3]).addClass("each_li");
        $(arr_li[id_p_r].childNodes[4]).addClass("each_li");
    }

    //处理所有列 arr_prev针对hub卡上在两个发送卡端口都是第一张时 重叠一起 处理hub数据时只有在发送卡端口不变时才递增,变了则下一个
    function mc_ajust_list(arr_each, ui_h, arr_li_list, num_item, arr_prev) {
    // 获取每段第一个值 用于记录
        var str_first_name = arr_each[0];
        // 记录当前不同值时的值
        var ui_para = 0;
        // 记录每一段的第一个
        var li_first = "";
        // 记录每一段的第二个之后
        var li_item_idx = "";
        // 记录发送卡端口
        var str_s_p_id = "";
        // 特殊处理hub卡数据
        var b_diff = true;

        if (2 === num_item) {
            b_diff = false;
        }

        for (var idx = 1; idx < arr_each.length; idx++) {
            // 开头第一个li标签
            li_first = arr_li_list[ui_para].childNodes[num_item];
            // 每一段的第一个li标签
            li_item_idx = arr_li_list[idx].childNodes[num_item];

            // 相同去除

            // 特殊处理 null 则单独一行
            if ("MC_LANG_OPTION_NULL" === str_first_name) {
                $(li_first).addClass("each_li");
                ui_para = idx;
                str_first_name = arr_each[idx];

                // 判断是否为最后一个
                if (ui_para === arr_each.length - 1) {
                    li_first = arr_li_list[ui_para].childNodes[num_item];
                    $(li_first).addClass("each_li");
                    break;
                }
                continue;
            }

            // 判断发送卡端口
            // 记录第一个发送卡端口值 (仅在处理hub卡时使用)
            if (2 === num_item) {
                str_s_p_id = arr_prev[idx - 1];
                if (str_s_p_id === arr_prev[idx]) {
                    b_diff = true;
                }
            }

            // 下一个跟记录当前段的第一个相同
            if (arr_each[idx] === str_first_name && b_diff) {
                $(li_item_idx).parent().css("justify-content", "flex-end").children().eq(4).css("border-right", "1px solid #ddd");
                // $(li_item_idx).css("display", "none");
                $(li_item_idx).css("visibility", "hidden");
                // $(li_item_idx).css({ "visibility": "hidden", "pointer-events": "none" });
                // 相同一直到尾
                if (idx === arr_each.length - 1) {
                    // +1 是算上最后一个
                    li_first.style.height = ui_h * (idx - ui_para + 1) + "px";
                    li_first.style.lineHeight = ui_h * (idx - ui_para + 1) + "px";
                    $(li_first).addClass("each_li");
                    break;
                }
                // 修改b_diff 判断发送卡端口值
                if (2 === num_item) {
                    b_diff = false;
                }


                continue;
            }
            // 赋值每段的第一个
            str_first_name = arr_each[idx];
            li_first.style.height = ui_h * (idx - ui_para) + "px";
            li_first.style.lineHeight = ui_h * (idx - ui_para) + "px";
            $(li_first).addClass("each_li");

            ui_para = idx;

            // 刚好最后一个跟前面不同
            if (idx === arr_each.length - 1) {
                li_first = arr_li_list[ui_para].childNodes[num_item];
                $(li_first).addClass("each_li");
                break;
            }
        }
    }
}
